<?php

Class Elearningmoodle extends CI_Model
{
	public function __construct()
	{
		parent::__construct();
	
		$this->load->database();
	}

	function addElearningCourseToCostCentre($selectedCCId, $mainCourseId, $selectedCCName)
	{
		$data['costcenterID']    = $selectedCCId;
		$data['course_id']   	 = $mainCourseId;
		$data['costcentrename']  = $selectedCCName;
		
		$query 	   = $this->db->insert('elearning_courses_costcentre', $data);
		return $query ;
	}
	
	
	
	function checkCourseAlreadyAssigned($selectedCCId, $mainCourseId)
	{
		return  $this->db->select('*')->from('elearning_courses_costcentre')->where(['costcenterID' => $selectedCCId, 'course_id' => $mainCourseId])->get()->result_array();
		
	}
	
	public function getAssignedCoursesToCostCentre($requestData) {
		
		$mainCourseId  = $requestData['mainCourseId'];
		
		$totalData = $this->db->from('elearning_courses_costcentre')->where('course_id', $mainCourseId)->count_all_results();
		
		$totalFiltered = $totalData; // when there is no search parameter then total number rows = total number filtered rows.
		
		if ( isset( $requestData['order'][0]['column'] ) && isset( $requestData['order'][0]['dir'] ) ) {
			$columnName = $requestData['columns'][$requestData['order'][0]['column']]['name'] ;
			$orderBy	= $requestData['order'][0]['dir'] ;
		} else {
			$columnName = "costcentrename" ;
			$orderBy	= "ASC" ;
		}
		
		if( !empty($requestData['search']['value']) ) {
			// if there is a search parameter
			$sql = "SELECT * ";
			$sql.=" FROM elearning_courses_costcentre";
			$sql.=" WHERE (costcentrename LIKE '%".$requestData['search']['value']."%' AND course_id = '".$mainCourseId."') ";    
			
			$sql.=" ORDER BY " .$columnName." ". $orderBy." LIMIT ".$requestData['start']." ,".$requestData['length']."   ";
			$query = $this->db->query($sql)->result_array();
			
			
			$totalFilteredSearch = "" ;
			$totalFilteredSearch = "SELECT * ";
			$totalFilteredSearch.=" FROM elearning_courses_costcentre";
			$totalFilteredSearch.=" WHERE (costcentrename LIKE '%".$requestData['search']['value']."%' AND course_id = '".$mainCourseId."') ";
			
			$querySearch = $this->db->query($totalFilteredSearch)->result_array();
			$totalFiltered = count($querySearch);
			
			
			

		} else {
			$query = $this->db->select('*')
				->from('elearning_courses_costcentre')
				->order_by($columnName, $orderBy)
				->limit($requestData['length'], $requestData['start'])
				->where('course_id', $mainCourseId)
				->get()
				->result_array();
				
		}

	  $data = [] ;
	  $counter = 0 ;
	 
	  $tableName = $requestData['tableName'];
	 
	  if ($tableName == "tableCCListPage") {
	 
		  foreach ($query as $row) {
			  
			$explode  = explode(" ", $row["costcentrename"]) ;  
			$initials = ( isset($explode[0]) ? $explode[0][0]:''). ( isset($explode[1]) ? $explode[1][0]:'') ;
			
			if (!$initials) {
				$initials = "-" ;
			}
			
			
			$data[$counter][] 	= '<figure><span class="userShortname">'.$initials.'</span></figure><span class = "nameListing">'.$row["costcentrename"].'</span><span class="user-active-time deletetraineeUser __deleteCourseForCostCentre" data-courseid = "'.$row["course_id"].'" data-costcentreid = "'.$row["costcenterID"].'"><a href="javascript:void(0);"><i class="fa fa-trash" aria-hidden="true"></i> Remove</a>' ;
			$counter++ ;
		  }
	  } else {
		  
		  foreach ($query as $row) {
			  
				$explode  = explode(" ", $row["costcentrename"]) ;  
				$initials = ( isset($explode[0]) ? $explode[0][0]:''). ( isset($explode[1]) ? $explode[1][0]:'') ;
				
				if (!$initials) {
					$initials = "-" ;
				}
				$data[$counter][] 	= '<span class="userShortname">'.$initials.'</span>'.$row["costcentrename"].'' ;
				$data[$counter][] 	= '<a href="javascript:void(0);" class= "__deleteCourseForCostCentre" data-courseid = "'.$row["course_id"].'" data-costcentreid = "'.$row["costcenterID"].'"><i class="fa fa-trash" aria-hidden="true"></i> Remove</a>' ;
				$counter++ ;
		 }
	  }

	  return $json_data = array(
			"draw"            => intval( $requestData['draw'] ),   // for every request/draw by clientside , they send a number as a parameter, when they recieve a response/data they first check the draw number, so we are sending same number in draw.
			"recordsTotal"    => intval( $totalData ),  // total number of records
			"recordsFiltered" => intval( $totalFiltered ), // total number of records after searching, if there is no searching then totalFiltered = totalData
			"data"            => $data   // total data array
			);

	}
	
	function getCourseCostCentres($courseId) {
		
		$getData = $this->db->select('*')->from('elearning_courses_costcentre')->where(['course_id' => $courseId])->get()->result_array();
		$data = "" ;
		
		
		if ($getData) {
			$counter = 1 ;
			foreach($getData as $value){
				
				$explode  = explode(" ", $value["costcentrename"]) ;  
				$initials = ( isset($explode[0]) ? $explode[0][0]:''). ( isset($explode[1]) ? $explode[1][0]:'') ;
		
				if (!$initials) {
					$initials = "-" ;
				}
				
				$data .= '<li><span class="userShortname">'.$initials.'</span>' ;
				
				
				if ( $counter == '3' ) {
					$moreUsersCount  =  ( count($getData) - 3 ) ;
					$data .= '<li class="last-member"><span class="userShortname">+'.$moreUsersCount.'</span></li>' ;
					break ;
					
				}
				
				$counter++ ;
			}
				
		}
		
		return $data ;
		
	}
	
	
	function addtraineeUser($postData, $username) {
		
	     $data['username'] 			 = $username ;
	     $data['first_name'] 		 = $postData['firstName'] ;
	     $data['last_name'] 		 = $postData['lastName'] ;
	     $data['email'] 			 = $postData['email'] ;
	     $data['password'] 			 = encrypt_string($postData['password']) ;
	     $data['mobile'] 			 = $postData['contactNumber'] ;
	     $data['created_by'] 		 = ( $this->session->userdata('type') == "superadmin" ? '1':'2') ;
	     $data['created_by_user_id'] = $this->session->userdata('user_id') ;
	     
		  $this->db->insert('elearning_trainee_users', $data);
		  $insert_id = $this->db->insert_id();
			
		  return  $insert_id;
	}
	
	
	function deleteTraineeUser($userId) {
		return $this->db->where('id',$userId)->delete('elearning_trainee_users');
	}
	
	function updateTraineeUserMoodleIdEmailStatus($data, $userId) {
		return $this->db->where('id', $userId)->update('elearning_trainee_users',$data);
	}
	
	function insertCourseData($postData) {
		 return  $this->db->insert('elearning_user_courses', $postData);
	}

	function getCourseUsers($courseId) {
	
	   $totalData = $this->db->from('elearning_user_courses')->where('course_id', $courseId)->count_all_results();
	
		$result  = $this->db->select('t1.course_id, t1.id as courseTableId, t2.first_name, t2.last_name,t2.email,t2.mobile,t2.moodle_user_id as moodleIdTraineeTable')
         ->from('elearning_user_courses as t1')
         ->join('elearning_trainee_users as t2', 't1.sentry_trainee_user_id = t2.id')
         ->where('t1.course_id', $courseId)
         ->get()
		 ->result_array();
		
		echo $totalData ; 
			
		debug($result, 1) ;
		
		echo "<br />Second Part<br />" ;
		
		
		$sql = "SELECT t1.course_id, t1.id as courseTableId, t2.first_name, t2.last_name,t2.email,t2.mobile,t2.moodle_user_id as moodleIdTraineeTable";
		$sql.=" FROM elearning_user_courses as t1 inner join elearning_trainee_users as t2 on t1.sentry_trainee_user_id = t2.id";
		$sql.=" WHERE (t2.first_name LIKE '%with%' OR t2.last_name LIKE '%with%') AND t1.course_id = '".$courseId."' ";    
		
		$query = $this->db->query($sql)->result_array();
		
		echo count($query) ; 
			
		debug($query) ;
	
		
		echo "second query" ;
		
		
		
		//$totalData = $this->db->from('elearning_user_courses')->where('course_id', $courseId)->count_all_results();
	
		$result  = $this->db->select('t1.course_id, t1.id as courseTableId, t2.first_name, t2.last_name,t2.email,t2.mobile,t2.moodle_user_id as moodleIdTraineeTable')
         ->from('elearning_trainee_users as t2')
         ->join('elearning_user_courses as t1', 't2.id= t1.sentry_trainee_user_id', 'right')
         ->where('t1.course_id !=', $courseId)
         ->get()
		 ->result_array();
		echo $this->db->last_query() ; 
		//echo $totalData ; 
			
		debug($result) ;
		
		
	}
	
	
	
	public function getAssignedTraineeToCourse($requestData) {
		
		$mainCourseId  = $requestData['mainCourseId'];
		
		$totalData = $this->db->from('elearning_user_courses')->where('course_id', $mainCourseId)->count_all_results();
		
		$totalFiltered = $totalData; // when there is no search parameter then total number rows = total number filtered rows.
		
		if ( isset( $requestData['order'][0]['column'] ) && isset( $requestData['order'][0]['dir'] ) ) {
			$columnName = "t2.".$requestData['columns'][$requestData['order'][0]['column']]['name'] ;
			$orderBy	= $requestData['order'][0]['dir'] ;
		} else {
			$columnName = "t2.first_name" ;
			$orderBy	= "ASC" ;
		}
		
		if( !empty($requestData['search']['value']) ) {
			// if there is a search parameter
			
			$sql = "SELECT t1.course_id, t1.id as courseTableId, t2.first_name, t2.last_name,t2.email,t2.mobile,t2.moodle_user_id as moodleIdTraineeTable";
			$sql.=" FROM elearning_user_courses as t1 inner join elearning_trainee_users as t2 on t1.sentry_trainee_user_id = t2.id";
			$sql.=" WHERE (t2.first_name LIKE '".$requestData['search']['value']."%' OR t2.last_name LIKE '".$requestData['search']['value']."%') AND t1.course_id = '".$mainCourseId."' ";  
			
			
			
			$sql.=" ORDER BY " .$columnName." ". $orderBy." LIMIT ".$requestData['start']." ,".$requestData['length']."   ";
			$query = $this->db->query($sql)->result_array();
			
			
			$totalFilteredSearch = "" ;
			$totalFilteredSearch = "SELECT t1.course_id, t1.id as courseTableId, t2.first_name, t2.last_name,t2.email,t2.mobile,t2.moodle_user_id as moodleIdTraineeTable";
			$totalFilteredSearch.=" FROM elearning_user_courses as t1 inner join elearning_trainee_users as t2 on t1.sentry_trainee_user_id = t2.id";
			$totalFilteredSearch.=" WHERE (t2.first_name LIKE '".$requestData['search']['value']."%' OR t2.last_name LIKE '".$requestData['search']['value']."%') AND t1.course_id = '".$mainCourseId."' ";
			
			$querySearch = $this->db->query($totalFilteredSearch)->result_array();
			$totalFiltered = count($querySearch);
			
			
			

		} else {
			
			$query  = $this->db->select('t1.course_id, t1.id as courseTableId, t2.first_name, t2.last_name,t2.email,t2.mobile,t2.moodle_user_id as moodleIdTraineeTable')
			->from('elearning_user_courses as t1')
			->join('elearning_trainee_users as t2', 't1.sentry_trainee_user_id = t2.id')
			->where('t1.course_id', $mainCourseId)
			->order_by($columnName, $orderBy)
			->limit($requestData['length'], $requestData['start'])
			->get()
			->result_array();
			
		}

	  $data = [] ;
	  $counter = 0 ;
	 
	  $tableName = $requestData['tableName'];
	 
	  if ($tableName == "tableAssignedTraineeToCoursePage") {
	 
		  foreach ($query as $row) {
			  
			 
			$initials =  $row["first_name"][0] .' '. $row["last_name"][0] ;
			
			$data[$counter][] 	= '<figure><span class="userShortname">'.$initials.'</span></figure><span class = "nameListing">'.$row["first_name"] .' '. $row["last_name"].'</span><span class="user-active-time deletetraineeUser __deleteCourseForTraineeUser" data-courseid = "'.$row["course_id"].'" data-coursetableid = "'.$row["courseTableId"].'" data-moodleidtrainee = "'.$row["moodleIdTraineeTable"].'"><a href="javascript:void(0);"><i class="fa fa-trash" aria-hidden="true"></i> Remove</a></span><span class="fa fa-fw fa-eye field-icon __updateTraineeUserInfoMoodelLocal" data-courseid = "'.$row["course_id"].'" data-moodleidtrainee = "'.$row["moodleIdTraineeTable"].'" data-firstname = "'.$row["first_name"].'" data-lastname = "'.$row["last_name"].'" data-email = "'.$row["email"].'" data-mobile = "'.$row["mobile"].'"></span>' ;
			$counter++ ;
		  }
	  } else {
		  
		  /*foreach ($query as $row) {
			  
				$explode  = explode(" ", $row["costcentrename"]) ;  
				$initials = ( isset($explode[0]) ? $explode[0][0]:''). ( isset($explode[1]) ? $explode[1][0]:'') ;
				
				if (!$initials) {
					$initials = "-" ;
				}
				$data[$counter][] 	= '<span class="userShortname">'.$initials.'</span>'.$row["costcentrename"].'' ;
				$data[$counter][] 	= '<a href="javascript:void(0);" class= "__deleteCourseForCostCentre" data-courseid = "'.$row["course_id"].'" data-costcentreid = "'.$row["costcenterID"].'"><i class="fa fa-trash" aria-hidden="true"></i> Remove</a>' ;
				$counter++ ;
		 }*/
	  }

	  return $json_data = array(
			"draw"            => intval( $requestData['draw'] ),   // for every request/draw by clientside , they send a number as a parameter, when they recieve a response/data they first check the draw number, so we are sending same number in draw.
			"recordsTotal"    => intval( $totalData ),  // total number of records
			"recordsFiltered" => intval( $totalFiltered ), // total number of records after searching, if there is no searching then totalFiltered = totalData
			"data"            => $data   // total data array
			);

	}
	
	
	function updateTrainee($dataToUpdateLocalDb, $moodleTeaineeId) {
		return $this->db->where('moodle_user_id', $moodleTeaineeId)->update('elearning_trainee_users',$dataToUpdateLocalDb);
	}
	
	
	
	function checkCourseAssignedToCCTrainee($selectedCCId, $mainCourseId)
	{
		return  $this->db->select('*')->from('elearning_user_courses')->where(['cost_centre_id' => $selectedCCId, 'course_id' => $mainCourseId])->get()->result_array();
		
	}
	
	
	function removeCostCentreAssignedtoCourse($selectedCCId, $mainCourseId) {
		return $this->db->where(['costcenterID' => $selectedCCId, 'course_id' => $mainCourseId])->delete('elearning_courses_costcentre');
	}
	
	function removeTraineeFromCourse($courseTableId) {
		return $this->db->where(['id' => $courseTableId])->delete('elearning_user_courses');
	}
}
